clc;
clear all;
% === sub1 === %

num_array = 6;
mid_count = ceil((1+num_array)/2)-1;
sn_1 = 3;
sn_2 = 1;

n_1 = 1;
sn_3 = 3 * n_1+5;
sn_4 = 3;
sn_6 = 3;
sn_5 = 2;
%sn_4 = 3;
%sn_5 = 3;
%%%%%%%%%%%%%%%%%%%%%%
n_2 = 2;
n_5 = 2;
n_3 = 4;
n_4 = n_1;
n_6 = n_1;

%%%%%%%%%%%%%%%%%%%%%%

interspace_12 = 4;

interspace_23 = 2+3*(n_1);

interspace_34 = sn_4;

interspace_45 = 4;

interspace_56 = 3;

%interspace_45 = 1 - sn_3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute initial position   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    if initial_count==1
        eval(['i_',num2str(initial_count),'=0',';'])
    else 
        eval(['i_',num2str(initial_count),'=i_',num2str(initial_count-1),'+(n_',num2str(initial_count-1),'-1)*sn_',num2str(initial_count-1),'+interspace_',num2str(initial_count-1),num2str(initial_count),';'])
    end 
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute sub arrays   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    eval(['sub',num2str(initial_count),'=[]',';'])
    eval(['count=n_',num2str(initial_count),';'])
    for sub_count=1:count
        eval(['sub',num2str(initial_count),'(sub_count) = (sub_count-1)','*sn_',num2str(initial_count),';'])
    end
    eval(['sub',num2str(initial_count),'=sub',num2str(initial_count),'+i_',num2str(initial_count),';'])
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% compute array address  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
arr_indices = [];
for p = 1:num_array
    eval(['arr_indices = [ arr_indices sub',num2str(p),'];'])
end
%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%     compute IDCA      %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    IDCA_count = num_array - initial_count;
    for add_count=1:IDCA_count
    eval(['IDCA_',num2str(initial_count),num2str(initial_count+add_count),'=IDCA(sub',num2str(initial_count),',','sub',num2str(initial_count+add_count),');'])
    end
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
arr_indices = arr_indices(:);
diffs = [];
w = [];
index_map = {};
if isempty(arr_indices)
    return;
end
n = length(arr_indices);
P = repmat(arr_indices', n, 1);
D = P' - P; % D_ij = d_i - d_j
[all_diffs, idx] = sort(D(:));
cur_diff = all_diffs(1);
start_idx = 1;
jj = 1;
for ii = 2:(n*n)
    if all_diffs(ii) ~= cur_diff
        diffs(jj) = cur_diff;
        index_map{jj} = idx(start_idx:ii-1);
        w(jj) = ii - start_idx;
        start_idx = ii;
        cur_diff = all_diffs(ii);
        jj = jj + 1;
    end
end
% add the last one
diffs(jj) = cur_diff;
index_map{jj} = idx(start_idx:end);
w(jj) = n*n - start_idx + 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ======plot figures ======= %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1);
x_label_min = min(arr_indices)-5;
x_label_max = max(arr_indices)+5;
y_label_min = 0;
y_label_max = 1.5;
subplot(2,1,1);
for iiii = 1:num_array
eval(['array_x_label = sub',num2str(iiii),';'])
z = length(array_x_label); 
y = 0.5*ones(z,1);
plot(array_x_label,y,'ko','MarkerFaceColor','r');
if z>1
    bound_left = min(array_x_label)-0.5;
    bound_right = max(array_x_label)+0.5;
    line([bound_left bound_left],[y_label_min y_label_max],'linestyle','--', 'Color','r', 'LineWidth', 2);
    line([bound_right bound_right],[y_label_min y_label_max],'linestyle','--', 'Color','r', 'LineWidth', 2);
    bound_mid = (bound_left+bound_right)/2;
    oo = num2str(iiii);
text(bound_mid,1,oo,'fontsize',13)
else
    bound_mid = array_x_label;
    bound_left = bound_mid-0.2;
    bound_right = bound_mid+0.2;
    ooo = num2str(iiii);
  line([bound_left bound_left],[y_label_min y_label_max],'linestyle','--', 'Color','r', 'LineWidth', 2);
  line([bound_right bound_right],[y_label_min y_label_max],'linestyle','--', 'Color','r', 'LineWidth', 2);
  text(bound_mid, 1,ooo,'fontsize',13)
end
hold on;
end
axis([x_label_min x_label_max y_label_min y_label_max]);
xlabel('Sparse array configuration');
%ylabel('W(x)');
title('Sparse array designed using ULA fitting');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(2,1,2);
    posi_set = diffs;
    posi_weight = w;
    posi_length = length(posi_set);
    X_label = zeros(1,posi_length);
    x = (posi_length+1)/2;
    plot(posi_set,posi_weight,'ko');
    hold on
    %line(X,y);
    plot([posi_set;posi_set],[X_label;posi_weight],'k');
    axis([0 x 0 max(posi_weight)+max(posi_weight)/4]);
    grid on;
    xlabel('x (Position Set of FDCA)');
    ylabel('W(x)');
    title('Weight Function');
    grid on;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  ======plot IDCAS  ======= %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
markers = {'+', 'o', 'd', '*','s','^','h','p','x','>', '+', 'o', 'd', '*','s','^','h','p','x','>','+', 'o', 'd', '*','s','^','h','p','x','>'};
colors  = {'m','b','c','g','y',[.30 1 .45],[.30 .5 .45],[.80 .7 .45],[0 .5 1],'c','k','b','r','g','m','c','k','b','r','g','m','c','k','b','r','g','m','c'};
lines = {'-',':','-.','--','-',':','-.','--','-',':','-.','--','-',':','-.','--'};
maker_size = 6;
for array_count = mid_count
    figure(2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  ======plot SUB 1  ======= %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    subplot(2,1,1);
    for i=1:num_array
        if array_count<i
 
            eval(['x_label = IDCA_',num2str(array_count),num2str(i),';'])
              plot(x_label,0.5,'ko',...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor',colors{i},...
                'MarkerSize',maker_size);
            hold on;
          
        else if array_count==i
         
            eval(['x_label = sub',num2str(array_count),'-i_',num2str(array_count),';']) 
              plot(x_label,0.5,'ko',...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','r',...
                'MarkerSize',maker_size);
            hold on;
            line([x_label' x_label'],[y_label_min y_label_max],'linestyle','--', 'Color',[.5 .5 .5], 'LineWidth', 1);
            else 
           
                eval(['x_label = IDCA_',num2str(i),num2str(array_count),';'])
                  plot(x_label,0.5,'ko',...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor',colors{i},...
                'MarkerSize',maker_size);
                hold on;
       
                end
            end
    end
            grid on;
            grid minor;
            axis([0 max(diffs) 0 1]);
            set(gca,'XTick',0:2:max(diffs));
            name=sprintf('FDCA');
            title(name);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  ======plot SUB 2  ======= %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            subplot(2,1,2);
            ylabels = cell(1, num_array+2);
            ylabels{1} = []; ylabels{num_array+2} = [];   
    for i=1:num_array
        if array_count<i            
            eval(['x_label = IDCA_',num2str(array_count),num2str(i),';'])
            IDCA_count = length(x_label);         
            y_label = (2*num_array+1-2*i)*ones(IDCA_count,1);
              plot(x_label,y_label,'ko',...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor',colors{i},...
                'MarkerSize',maker_size);         
            hold on;       
            grid on;
            grid minor;    
            eval(['name',num2str(array_count),num2str(i),'=sprintf(''IDCA',num2str(array_count),num2str(i),''');'])
            eval([' ylabels{num_array+2-i} = ','name',num2str(array_count),num2str(i),';'])             
          
        else if array_count==i       
            eval(['x_label = sub',num2str(array_count),'-i_',num2str(array_count),';']) 
            IDCA_count = length(x_label);         
            y_label = (2*num_array+1-2*i)*ones(IDCA_count,1);
               plot(x_label,y_label,'ko',...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','r',...
                'MarkerSize',maker_size);
            hold on;
            line([x_label' x_label'],[y_label_min 2*num_array],'linestyle','--', 'Color',[.5 .5 .5], 'LineWidth', 1);
            grid on;
            grid minor;
            
            eval(['name',num2str(array_count),num2str(i),'=sprintf(''SDCA',num2str(array_count),''');'])         
            eval([' ylabels{num_array+2-i} = ','name',num2str(array_count),num2str(i),';'])         
            else 
              
                eval(['x_label = IDCA_',num2str(i),num2str(array_count),';'])
                IDCA_count = length(x_label);         
                y_label = (2*num_array+1-2*i)*ones(IDCA_count,1);
                   plot(x_label,y_label,'ko',...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor',colors{i},...
                'MarkerSize',maker_size);
                hold on;
          
                grid on;
                grid minor;
                          
                eval(['name',num2str(array_count),num2str(i),'=sprintf(''IDCA',num2str(i),num2str(array_count),''');'])
                eval([' ylabels{num_array+2-i} = ','name',num2str(array_count),num2str(i),';'])
                end
            end
    end
         axis([0 max(diffs) 0 2*num_array]);            
         set(gca,'XTick',0:2:max(diffs),...
        'YTick', -1:2:2*num_array,...
        'YTickLabel', ylabels);
end